# 画面設計書 13-File Hex Viewer

## 概要

本ドキュメントは、VBCorLibのMemoryMappedFileクラス機能をデモンストレーションするFile Hex Viewer画面の設計書である。

### 本画面の処理概要

この画面は、任意のファイルを16進数（Hex）ダンプ形式で表示するビューアアプリケーションである。MemoryMappedFile（メモリマップトファイル）技術を使用することで、大容量ファイルも効率的に仮想表示できる。左側に行番号（オフセット）、右側に16進数データを表示し、VScrollBarでスクロール操作を行う。

**業務上の目的・背景**：VBCorLibが提供するMemoryMappedFileクラスの使用方法をVB6開発者に紹介することを目的としている。メモリマップトファイルはWindowsの仮想メモリ機能を活用してファイル全体をメモリにロードせずにアクセスできるため、大容量ファイルの処理に適している。また、StringBuilder、BinaryReaderなどの補助クラスの活用方法もデモンストレーションしている。

**画面へのアクセス方法**：FileHexViewer.vbpプロジェクトをVB6 IDEで開き、実行（F5）することでフォームが起動する。スタートアップフォームとしてForm1が設定されている。

**主要な操作・処理内容**：
1. メニューの「File > Open」からファイルを選択する
2. ファイルがメモリマップされ、最初のページ（24行分）が表示される
3. VScrollBarでスクロールすると、表示位置が更新される
4. 左側PictureBoxに16進数行番号、右側PictureBoxに16進数データが表示される
5. 1行あたり32バイト（8個の4バイトチャンク）を表示

**画面遷移**：本画面は独立したデモアプリケーションであり、他の画面への遷移は存在しない。ファイルオープンダイアログ（CommonDialog）のみが呼び出される。

**権限による表示制御**：特になし。ローカルファイルシステムへの読み取りアクセス権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 95 | MemoryMappedFile | 主機能 | ファイルのメモリマッピング（CreateFromFile） |
| 97 | MemoryMappedViewStream | 主機能 | メモリマップトファイルのストリームアクセス（CreateViewStream、Position、ReadByte） |
| 30 | BinaryReader | 主機能 | バイナリデータの読み込み（ReadInt32） |
| 17 | StringBuilder | 補助機能 | 16進数ダンプ表示の構築（AppendFormat、AppendString） |
| 12 | BitConverter | 補助機能 | バイト配列から整数への変換（コード内でコメントアウト） |
| 14 | CorMath | 補助機能 | 最大行数の切り上げ計算（Ceiling） |

## 画面種別

ビューア（単一ファイル表示）

## URL/ルーティング

該当なし（VB6デスクトップアプリケーション）

## 入出力項目

### 入力項目

| 項目名 | データ型 | 必須 | 説明 |
|--------|----------|------|------|
| ファイルパス | String | Yes | CommonDialogで選択されるファイルのフルパス |
| スクロール位置 | Long | No | VScrollBarの値（-32768〜Max）で表示開始行を指定 |

### 出力項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| 行番号表示 | String | 16進数オフセット値（8桁） |
| 16進数データ表示 | String | ファイル内容の16進数ダンプ |

## 表示項目

### 行番号エリア（Picture2）

| 項目名 | 書式 | 説明 |
|--------|------|------|
| オフセット | {0:X8} | ファイル先頭からのバイトオフセット（8桁16進数） |

### 16進数データエリア（Picture1）

| 項目名 | 書式 | 説明 |
|--------|------|------|
| データ | {0:X8} | 4バイト単位の16進数表現（1行32バイト=8チャンク） |

### 定数定義

| 定数名 | 値 | 説明 |
|--------|-----|------|
| LINES_PER_PAGE | 24 | 1ページあたりの表示行数 |
| BYTES_PER_LINE | 32 | 1行あたりのバイト数 |

## イベント仕様

### 1-mnuFileOpen_Click

メニューの「File > Open」クリック時に実行される。

**処理フロー**：
1. CommonDialogでファイル選択ダイアログを表示
2. キャンセル時はエラートラップで処理を終了
3. LoadFile関数を呼び出してファイルをロード

### 2-VScroll1_Change / VScroll1_Scroll

スクロールバー操作時に実行される。

**処理フロー**：
1. UpdateDisplay関数を呼び出して表示を更新

### 3-Form_Unload

フォーム終了時に実行される。

**処理フロー**：
1. CloseFile関数を呼び出してリソースを解放

### 4-LoadFile（Private Sub）

ファイルをロードして初期表示を行う。

**処理フロー**：
1. OpenFile関数でファイルをメモリマップ
2. ファイルサイズから最大行数を計算（Ceiling使用）
3. スクロールバーのMax値を設定（2MB以上でオーバーフローの可能性あり）
4. スクロールバーを初期位置（Min）に設定
5. UpdateDisplay関数で表示更新

### 5-OpenFile（Private Sub）

ファイルをメモリマップして読み取り可能にする。

**処理フロー**：
1. CloseFile関数で既存ファイルを解放
2. MemoryMappedFile.CreateFromFileでメモリマップトファイル作成
3. CreateViewStreamでストリームビューを取得
4. NewBinaryReaderでバイナリリーダーを作成（LeaveOpen:=True）

### 6-DisplayPage（Private Sub）

現在位置のページを描画する。

**処理フロー**：
1. mPageBuilder、mLineNumberBuilderの長さを0にリセット
2. 表示開始位置（Index）を計算
3. mStream.Positionで読み取り位置を設定
4. For文で1ページ分（32*24=768バイト）をループ
5. 32バイトごとに行番号を追加
6. mReader.ReadInt32で4バイトずつ読み込み、X8書式で追加
7. 32バイトごとに改行を追加
8. ファイル末尾の端数処理
9. Picture1、Picture2にPrintで表示

### 7-CloseFile（Private Sub）

メモリマップトファイルを解放する。

**処理フロー**：
1. mStreamがNothingでなければCloseStreamで閉じる
2. mStreamをNothingに設定

### 8-UpdateDisplay（Private Sub）

スクロール位置に基づいて表示を更新する。

**処理フロー**：
1. mTopLineをスクロールバー値+32768で計算（オフセット補正）
2. DisplayPage関数を呼び出し

## データベース更新仕様

該当なし（ファイルの読み取りのみ）

## メッセージ仕様

| 種別 | 条件 | メッセージ内容 |
|------|------|---------------|
| なし | - | 本画面ではメッセージボックスは使用しない |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| ファイル選択キャンセル | errTrapラベルへジャンプし、処理を終了（エラー表示なし） |
| ファイル読み込みエラー | VBのデフォルトエラー処理に委譲 |
| スクロールバーオーバーフロー | 2MB超のファイルでMaxが-32768を下回る場合、-32768に制限 |

## 備考

- COMDLG32.OCX（CommonDialog）が必要
- VBCorLib 3.0ライブラリ（vbcorlib3.dll）への参照設定が必要
- VBのScrollBarはInteger範囲（-32768〜32767）のため、大容量ファイルでは制限がある
- フォントはCourier 9.75ptの等幅フォントを使用
- コメントアウトされたコード（BitConverter.ToLong、mFile.DeleteView等）は旧実装の痕跡

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、メモリマップトファイルの概念とVBCorLibのクラス構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Form1.frm（変数宣言部） | `Examples/IO Examples/FileHexViewer/Form1.frm` | mFile（MemoryMappedFile）、mStream（MemoryMappedViewStream）、mReader（BinaryReader）、mPageBuilder/mLineNumberBuilder（StringBuilder）の役割を理解する |

**読解のコツ**: メモリマップトファイルは、ファイル全体をメモリにロードせずに仮想的にアクセスできるWindows機能。mStreamを介してファイル位置を指定し、mReaderでデータを読み取る。

#### Step 2: エントリーポイントを理解する

処理の起点となるフォームのイベントハンドラを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Form1.frm | `Examples/IO Examples/FileHexViewer/Form1.frm` | ファイルオープン、スクロール操作、フォーム終了時の処理の流れを理解する |

**主要処理フロー**:
1. **行239-248（mnuFileOpen_Click）**: ファイル選択とロード処理
2. **行251-253（VScroll1_Change）**: スクロール変更時の表示更新
3. **行255-257（VScroll1_Scroll）**: スクロールドラッグ時の表示更新
4. **行231-237（Form_Unload）**: リソース解放

#### Step 3: ファイル読み込み処理の理解

メモリマップトファイルのオープン処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Form1.frm | `Examples/IO Examples/FileHexViewer/Form1.frm` | LoadFile、OpenFile関数でのMemoryMappedFile操作方法 |

**主要処理フロー**:
- **行108-126（LoadFile）**: ファイルロードとスクロールバー設定
- **行130-140（OpenFile）**: MemoryMappedFile.CreateFromFile、CreateViewStream、NewBinaryReader
- **行207-219（CloseFile）**: ストリームのクローズ処理

#### Step 4: 表示処理の理解

16進数ダンプ表示の構築処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Form1.frm | `Examples/IO Examples/FileHexViewer/Form1.frm` | DisplayPage関数でのStringBuilder活用とPictureBoxへの描画 |

**主要処理フロー**:
- **行145-202（DisplayPage）**: ページ描画処理の全体
- **行147-148**: StringBuilderの初期化
- **行152-153**: 読み取り開始位置の設定
- **行156-175**: メインループ（4バイトずつ読み込み、16進数変換）
- **行163**: 行番号の追加（32バイトごと）
- **行168**: ReadInt32で4バイト読み込み、X8書式で追加
- **行174**: 改行の追加（32バイトごと）
- **行181-192**: ファイル末尾の端数処理
- **行196-201**: PictureBoxへの表示

### プログラム呼び出し階層図

```
Form1.frm
    │
    ├─ mnuFileOpen_Click (行239)
    │      ├─ CommonDialog.ShowOpen (ファイル選択)
    │      └─ LoadFile (行108)
    │             ├─ OpenFile (行130)
    │             │      ├─ CloseFile (行207)
    │             │      ├─ MemoryMappedFile.CreateFromFile (VBCorLib)
    │             │      ├─ CreateViewStream (VBCorLib)
    │             │      └─ NewBinaryReader (VBCorLib)
    │             ├─ Ceiling (VBCorLib) - 最大行計算
    │             ├─ VScroll1設定
    │             └─ UpdateDisplay (行223)
    │                    └─ DisplayPage (行145)
    │
    ├─ VScroll1_Change / VScroll1_Scroll (行251, 255)
    │      └─ UpdateDisplay (行223)
    │             ├─ mTopLine計算
    │             └─ DisplayPage (行145)
    │                    ├─ mPageBuilder.Length = 0
    │                    ├─ mLineNumberBuilder.Length = 0
    │                    ├─ mStream.Position設定
    │                    ├─ For Loop
    │                    │      ├─ mLineNumberBuilder.AppendFormat (行番号)
    │                    │      └─ mReader.ReadInt32 → mPageBuilder.AppendFormat
    │                    ├─ 端数処理 (行181-192)
    │                    ├─ Picture1.Print (データ表示)
    │                    └─ Picture2.Print (行番号表示)
    │
    └─ Form_Unload (行231)
           └─ CloseFile (行207)
                  └─ mStream.CloseStream
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ファイル選択 ───────────▶ CreateFromFile ──────────────▶ MemoryMappedFile
(CommonDialog)            (行135)                        (mFile)
                              │
                              ▼
                         CreateViewStream ─────────────▶ MemoryMappedViewStream
                         (行138)                         (mStream)
                              │
                              ▼
                         NewBinaryReader ──────────────▶ BinaryReader
                         (行139)                         (mReader)

スクロール位置 ─────────▶ UpdateDisplay ────────────────▶ mTopLine
(VScroll1.Value)          (行223-225)                     (表示開始行)
                              │
                              ▼
                         mStream.Position ─────────────▶ 読み取り位置設定
                         (行153)
                              │
                              ▼
                         mReader.ReadInt32 ────────────▶ 4バイトデータ
                         (行168)
                              │
                              ▼
                         StringBuilder.AppendFormat ───▶ 16進数文字列
                         (行163, 168)
                              │
                              ▼
                         Picture.Print ────────────────▶ 画面表示
                         (行196-201)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Form1.frm | `Examples/IO Examples/FileHexViewer/Form1.frm` | ソース | メインフォーム。UI、イベント処理、16進数表示 |
| FileHexViewer.vbp | `Examples/IO Examples/FileHexViewer/FileHexViewer.vbp` | プロジェクト | VBプロジェクトファイル |
| vbcorlib3.dll | `Binaries/Compiled/vbcorlib3.dll` | ライブラリ | VBCorLibランタイム |
| COMDLG32.OCX | System32 | OCX | CommonDialogコントロール |
